﻿Option Strict Off
Imports System.Data.Odbc

Public Class frmSubPerbandinganBerpasangan
    Dim jlhKriteria As Integer = 0
    Dim strKriteria(), strkode_Kriteria(), strsub_Kriteria() As String
    Dim jlhBulat As Integer = 3
    Dim adaKriteria As Boolean = False
    Dim cKode_kriteria As String

    Private Sub frmPerbandinganBerpasangan_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        loading()
    End Sub

    Sub loading()
        Koneksi()
        Dim rs As OdbcDataReader
        Dim cmd As OdbcCommand

        Dim lstKriteria As New List(Of String)
        Dim lstkode_Kriteria As New List(Of String)

        cmd = New OdbcCommand("select kode_kriteria,nama_kriteria from `tbkriteria` order by `kode_kriteria` asc", Conn)
        rs = cmd.ExecuteReader
        If Not rs.HasRows Then
            MsgBox("Data Tidak Ada!")
            Exit Sub
        End If

        While rs.Read
            lstKriteria.Add(rs("nama_kriteria"))
            lstkode_Kriteria.Add(rs("kode_kriteria"))
        End While
        strKriteria = lstKriteria.ToArray
        strkode_Kriteria = lstkode_Kriteria.ToArray
        jlhKriteria = lstKriteria.Count
        rs.Close()

        ' Dim lstKriteria() As String = GetList("kriteria", "kriteria", "urutan")
        cmbKriteria.Items.Clear()
        For i = 0 To jlhKriteria - 1
            cmbKriteria.Items.Add(lstKriteria(i))
        Next
    End Sub

    Sub BuatMatriks()
        Dim rs As OdbcDataReader
        Dim cmd As OdbcCommand

        Dim lstKriteria As New List(Of String)
        Dim lstsub_Kriteria As New List(Of String)
        Dim lstKriteria2 As New List(Of String)
        cmd = New OdbcCommand("select kode_sub,`Sub_Kriteria` from `tbsub_kriteria` where `kode_kriteria`='" & cKode_kriteria & "' order by `kode_kriteria` asc", Conn)
        rs = cmd.ExecuteReader
        adaKriteria = rs.HasRows
        If adaKriteria Then
            dg1.Columns.Clear()

            'buat matriks perbandingan berpasangan
            While rs.Read
                lstKriteria.Add(rs("sub_kriteria"))
                lstsub_Kriteria.Add(rs("kode_sub"))
                dg1.Columns.Add(rs("sub_kriteria"), rs("sub_kriteria"))
            End While
            strKriteria = lstKriteria.ToArray
            strsub_Kriteria = lstsub_Kriteria.ToArray
            jlhKriteria = lstKriteria.Count
            rs.Close()
            dg1.Rows.Add(jlhKriteria + 1)
            For i = 0 To jlhKriteria - 1
                Dim hd As New DataGridViewRowHeaderCell
                dg1.Rows(i).HeaderCell.Value = dg1.Columns(i).HeaderText
            Next
            dg1.Rows(jlhKriteria).HeaderCell.Value = "Jumlah"

            'buat matriks nilai kriteria
            dg2.Columns.Clear()
            For i = 0 To jlhKriteria - 1
                dg2.Columns.Add("", lstKriteria(i))
            Next

            dg2.Rows.Add(jlhKriteria + 1)
            For i = 0 To jlhKriteria - 1
                dg2.Rows(i).HeaderCell.Value = dg2.Columns(i).HeaderText
            Next
            dg2.Rows(jlhKriteria).HeaderCell.Value = "Jumlah"
            dg2.Columns.Add("", "Jumlah Baris")
            dg2.Columns.Add("", "Priority Vector" & vbCrLf & "Normalisasi")
            dg2.Columns.Add("", "Perioritas" & vbCrLf & "Sub_Kriteria")

            'buat matriks penjumlahan tiap baris        

            dg3.Columns.Clear()
            cmd = New OdbcCommand("select `Sub_Kriteria` from `tbsub_kriteria` where `kode_kriteria`='" & cKode_kriteria & "' order by `kode_kriteria` asc", Conn)
            rs = cmd.ExecuteReader
            adaKriteria = rs.HasRows
            While rs.Read
                lstKriteria2.Add(rs("sub_kriteria"))
                dg3.Columns.Add(rs("sub_kriteria"), rs("sub_kriteria"))
            End While
            strKriteria = lstKriteria2.ToArray
            jlhKriteria = lstKriteria2.Count
            rs.Close()
            dg3.Rows.Add(jlhKriteria)
            For i = 0 To jlhKriteria - 1
                Dim hd As New DataGridViewRowHeaderCell
                dg3.Rows(i).HeaderCell.Value = dg3.Columns(i).HeaderText
            Next
            'dg1.Rows(jlhKriteria).HeaderCell.Value = "Jumlah"
            dg3.Columns.Add("", "Jumlah Baris")

            'buat matriks rasio konsistensi
            dg4.Columns.Clear()
            dg4.Columns.Add("", "Jumlah Baris")
            dg4.Columns.Add("", "Priority Vector" & vbCrLf & "Normalisasi")
            dg4.Columns.Add("", "Hasil")
            dg4.Rows.Add(jlhKriteria + 1)
            For i = 0 To jlhKriteria - 1
                dg4.Rows(i).HeaderCell.Value = lstKriteria(i)
            Next
            dg4.Rows(jlhKriteria).HeaderCell.Value = "Jumlah"

            isiMatriksPerbandinganBerpsangan()
        Else
            rs.Close()
            MsgBox("Data Sub Kriteria Tidak ada, Isi dahulu!")
        End If

        For Each col As DataGridViewColumn In dg1.Columns
            col.SortMode = DataGridViewColumnSortMode.Programmatic
        Next

        For Each col As DataGridViewColumn In dg2.Columns
            col.SortMode = DataGridViewColumnSortMode.Programmatic
        Next

        For Each col As DataGridViewColumn In dg3.Columns
            col.SortMode = DataGridViewColumnSortMode.Programmatic
        Next
    End Sub

    Sub isiMatriksPerbandinganBerpsangan()
        If adaKriteria Then
            Dim cmd As OdbcCommand
            Dim rs As OdbcDataReader

            cmd = New OdbcCommand("select * from `tbpberpasangan` where `kode_kriteria`='" & cKode_kriteria & "'", Conn)
            rs = cmd.ExecuteReader
            If rs.HasRows Then
                For i = 0 To jlhKriteria - 1
                    dg1.Item(i, i).Value = 1
                Next
                While rs.Read
                    If Val(rs("rowIndex")) > Val(rs("colIndex")) Then
                        dg1.Item(rs("colIndex"), rs("rowIndex")).value = Val(Format(rs("nilai"), "0.000"))
                    Else
                        dg1.Item(rs("colIndex"), rs("rowIndex")).value = Val(rs("nilai"))
                    End If
                End While
                rs.Close()
                hitungMatriksPerbandinganBerpasangan()
                hitungMatriksNilaiKriteria()
                hitungMatriksPenjumlahanTiapBaris()
                hitungMatriksRasioKonsistensi()
                hitungLainya()
            Else
                rs.Close()
                For i = 0 To jlhKriteria - 1
                    dg1.Item(i, i).Value = 1
                Next
            End If
        End If
    End Sub

    Private Sub btnProses_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnProses.Click
        hitungMatriksPerbandinganBerpasangan()
        hitungMatriksNilaiKriteria()
        hitungMatriksPenjumlahanTiapBaris()
        hitungMatriksRasioKonsistensi()
        hitungLainya()
    End Sub

    Sub hitungMatriksPerbandinganBerpasangan()
        If adaKriteria Then
            For i = 0 To jlhKriteria - 1
                For j = 0 To jlhKriteria - 1
                    If i > j Then
                        dg1.Item(j, i).Value = Math.Round(Val(dg1.Item(j, j).Value) / Val(dg1.Item(i, j).Value), jlhBulat)
                    End If
                Next
            Next

            For i = 0 To jlhKriteria - 1
                Dim jlh As Double = 0
                For j = 0 To jlhKriteria - 1
                    jlh += Val(dg1.Item(i, j).Value)
                Next
                dg1.Item(i, jlhKriteria).Value = Math.Round(jlh, jlhBulat)

            Next
        End If
        dg1.ColumnHeadersDefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter
        For k As Integer = 0 To jlhKriteria - 1
            dg1.Columns(k).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter
        Next
    End Sub

    Sub hitungMatriksNilaiKriteria()
        If adaKriteria Then
            For i = 0 To jlhKriteria - 1
                For j = 0 To jlhKriteria - 1
                    dg2.Item(i, j).Value = Math.Round(Val(dg1.Item(i, j).Value) / Val(dg1.Item(i, jlhKriteria).Value), jlhBulat)
                Next
            Next

            For row = 0 To jlhKriteria - 1
                Dim jlh As Double = 0
                For kol = 0 To jlhKriteria - 1
                    jlh += Val(dg2.Item(kol, row).Value)
                Next
                dg2.Item(jlhKriteria, row).Value = Math.Round(jlh, jlhBulat)
            Next

            Dim lstPSK As New List(Of Double)
            For row = 0 To jlhKriteria - 1
                dg2.Item(jlhKriteria + 1, row).Value = Math.Round(Val(dg2.Item(jlhKriteria, row).Value) / jlhKriteria, jlhBulat)
                lstPSK.Add(Math.Round(Val(dg2.Item(jlhKriteria + 1, row).Value), jlhBulat))
            Next

            For i As Integer = 0 To jlhKriteria - 1
                dg2.Item(jlhKriteria + 2, i).Value = Math.Round(lstPSK(i) / GetMax(lstPSK.ToArray), jlhBulat)
            Next

            For i As Integer = 0 To jlhKriteria + 2
                Dim jlh As Double = 0
                For j As Integer = 0 To jlhKriteria - 1
                    jlh += dg2.Item(i, j).Value
                Next
                dg2.Item(i, jlhKriteria).Value = Math.Round(jlh, jlhBulat)
            Next
        End If
        dg2.ReadOnly = True
        dg2.ColumnHeadersDefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter
        dg2.DefaultCellStyle.ForeColor = Color.Blue
        dg2.RowHeadersDefaultCellStyle.BackColor = Color.DeepPink
        dg2.AlternatingRowsDefaultCellStyle.BackColor = Color.Yellow
        dg2.SelectionMode = DataGridViewSelectionMode.FullRowSelect
        For k As Integer = 0 To jlhKriteria + 2
            dg2.Columns(k).DefaultCellStyle.Format = "0.000"
            dg2.Columns(k).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter
        Next
    End Sub

    Sub hitungMatriksPenjumlahanTiapBaris() ' td dimatikan
        For row = 0 To jlhKriteria - 1
            Dim jlh As Double = 0
            For kol = 0 To jlhKriteria - 1
                dg3.Item(kol, row).Value = Math.Round(Val(dg2.Item(jlhKriteria + 1, row).Value) * Val(dg1.Item(kol, row).Value), jlhBulat)
                jlh += Math.Round(Val(dg2.Item(jlhKriteria + 1, row).Value) * Val(dg1.Item(kol, row).Value), jlhBulat)
            Next
            dg3.Item(jlhKriteria, row).Value = jlh
        Next
        dg3.ReadOnly = True
        dg3.ColumnHeadersDefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter
        dg3.DefaultCellStyle.ForeColor = Color.Blue
        dg3.RowHeadersDefaultCellStyle.BackColor = Color.DeepPink
        dg3.AlternatingRowsDefaultCellStyle.BackColor = Color.Yellow
        dg3.SelectionMode = DataGridViewSelectionMode.FullRowSelect
        For k As Integer = 0 To jlhKriteria
            dg3.Columns(k).DefaultCellStyle.Format = "0.000"
            dg3.Columns(k).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter
        Next
    End Sub

    Sub hitungMatriksRasioKonsistensi()
        If adaKriteria Then
            Dim jlh As Double = 0
            For row = 0 To jlhKriteria - 1
                dg4.Item(0, row).Value = Val(dg3.Item(jlhKriteria, row).Value)
                dg4.Item(1, row).Value = Val(dg2.Item(jlhKriteria + 1, row).Value)
                dg4.Item(2, row).Value = Val(dg4.Item(0, row).Value) + Val(dg4.Item(1, row).Value)
                jlh += Val(dg4.Item(2, row).Value)
            Next
            dg4.Item(2, jlhKriteria).Value = Math.Round(jlh, jlhBulat)
            jlh = 0
        End If
        dg4.ReadOnly = True
        dg4.DefaultCellStyle.ForeColor = Color.Blue
        dg4.RowHeadersDefaultCellStyle.BackColor = Color.DeepPink
        dg4.AlternatingRowsDefaultCellStyle.BackColor = Color.Yellow
        dg4.SelectionMode = DataGridViewSelectionMode.FullRowSelect
        dg4.ColumnHeadersDefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter
        For k As Integer = 0 To 2
            dg4.Columns(k).DefaultCellStyle.Format = "0.000"
            dg4.Columns(k).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter
        Next
    End Sub

    Sub hitungLainya()
        If adaKriteria Then
            nMaks.Text = "λ Maks : " & Format(Math.Round(Val(dg4.Item(2, jlhKriteria).Value) / jlhKriteria, jlhBulat), "0.000")
            ik.Text = "Indeks Konsistensi : " & Format(Math.Round(((Val(dg4.Item(2, jlhKriteria).Value) / jlhKriteria) - jlhKriteria) / jlhKriteria, jlhBulat), "0.000")
            rk.Text = "Rasio Konsistensi : " & Format(Math.Round((((Val(dg4.Item(2, jlhKriteria).Value) / jlhKriteria) - jlhKriteria) / jlhKriteria) / NilaiIndeksRandom(jlhKriteria), jlhBulat), "0.000")
            Dim rc As Double = Val(Format(Math.Round((((Val(dg4.Item(2, jlhKriteria).Value) / jlhKriteria) - jlhKriteria) / jlhKriteria) / NilaiIndeksRandom(jlhKriteria), jlhBulat), "0.000"))
            If rc < 0.1 Then
                k.Text = "Konsistensi : Konsisten"
            Else
                k.Text = "Konsistensi : Tidak Konsisten"
            End If
        End If
    End Sub

    Private Sub btnSimpan_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSimpan.Click
        If adaKriteria Then
            Dim cmd As OdbcCommand
            Dim cBulat, cBulat2 As String
            cmd = New OdbcCommand("delete from `tbpberpasangan` where `kode_kriteria`='" & cKode_kriteria & "'", Conn)
            cmd.ExecuteNonQuery()

            For i = 0 To jlhKriteria - 1
                For j = 0 To jlhKriteria - 1
                    cBulat = Replace(dg1.Item(j, i).Value, ",", ".")
                    cmd = New OdbcCommand("insert into `tbpberpasangan` values('" & cKode_kriteria & "','" & j & "','" & i & "','" & cBulat & "')", Conn)
                    cmd.ExecuteNonQuery()
                Next
            Next

            cmd = New OdbcCommand("delete from `tbprioritas` where `kode_kriteria`='" & cKode_kriteria & "'", Conn)
            cmd.ExecuteNonQuery()

            For i = 0 To jlhKriteria - 1
                cBulat2 = Replace(Val(dg2.Item(jlhKriteria + 2, i).Value), ",", ".")
                cmd = New OdbcCommand("insert into `tbprioritas` values('" & cKode_kriteria & "','" & strsub_Kriteria(i) & "','" & cBulat2 & "')", Conn)
                cmd.ExecuteNonQuery()
            Next
            MsgBox("Data Tersimpan")
        End If
    End Sub

    Private Sub cmbKriteria_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbKriteria.SelectedIndexChanged
        cmd = New OdbcCommand("Select * from tbkriteria where nama_kriteria='" & cmbKriteria.Text & "'", Conn)
        rd = cmd.ExecuteReader
        rd.Read()
        If rd.HasRows Then
            cKode_kriteria = rd.Item(0)
            Call BuatMatriks()
        End If

    End Sub

    Private Sub dg1_CellBeginEdit(ByVal sender As Object, ByVal e As System.Windows.Forms.DataGridViewCellCancelEventArgs) Handles dg1.CellBeginEdit
        If e.ColumnIndex > e.RowIndex Then
            e.Cancel = False
            If Val(dg1.Item(e.ColumnIndex, e.RowIndex).Value) < 1 Then
                dg1.Item(e.ColumnIndex, e.RowIndex).Value = 1
            End If
        Else
            e.Cancel = True
        End If
    End Sub

    Private Sub dg1_CellEndEdit(ByVal sender As Object, ByVal e As System.Windows.Forms.DataGridViewCellEventArgs) Handles dg1.CellEndEdit
        If e.ColumnIndex > e.RowIndex Then
            If Val(dg1.Item(e.ColumnIndex, e.RowIndex).Value) < 1 Then
                dg1.Item(e.ColumnIndex, e.RowIndex).Value = 1
            End If
        End If
    End Sub

    Private Sub btnTutup_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnTutup.Click
        Me.Dispose()
    End Sub

    Private Sub btnNilaiPerioritas_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNilaiPerioritas.Click
        frmNilaiPrioritasKriteria.Show(Me)
    End Sub
    Private Sub dg1_EditingControlShowing(ByVal sender As Object, ByVal e As System.Windows.Forms.DataGridViewEditingControlShowingEventArgs) Handles dg1.EditingControlShowing
        If e.Control.GetType.ToString() = "System.Windows.Forms.DataGridViewTextBoxEditingControl" Then
            Dim c As DataGridViewTextBoxEditingControl = CType(e.Control, DataGridViewTextBoxEditingControl)
            RemoveHandler c.KeyPress, AddressOf GridViewTextBox_KeyPress
            AddHandler c.KeyPress, AddressOf GridViewTextBox_KeyPress
        End If
    End Sub
    Private Sub GridViewTextBox_KeyPress(ByVal sender As Object, ByVal ex As KeyPressEventArgs)
        ' If dg1.CurrentCell.ColumnIndex = 1 Then
        If ((Asc(ex.KeyChar) < 48 Or Asc(ex.KeyChar) > 57) And Asc(ex.KeyChar) <> 8) Then
            ex.Handled = True
        End If
        ' End If
    End Sub

    Private Sub dg4_CellContentClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DataGridViewCellEventArgs) Handles dg4.CellContentClick

    End Sub

    Private Sub dg2_CellContentClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DataGridViewCellEventArgs) Handles dg2.CellContentClick

    End Sub
End Class